-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema surveyjs
--

-- CREATE DATABASE IF NOT EXISTS surveyjs;
-- USE surveyjs;


--
-- Definition of table `user`
--

DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `id_user` int(11) NOT NULL,
  `login` varchar(16) NOT NULL,
  `password` varchar(100) NOT NULL,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY (`id_user`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `user`
--

/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id_user`,`login`,`password`,`name`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Administrator');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;




--
-- Definition of table `status`
--

DROP TABLE IF EXISTS `status`;
CREATE TABLE `status` (
  `id_status` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `title` varchar(15) NOT NULL,
  PRIMARY KEY (`id_status`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `status`
--

/*!40000 ALTER TABLE `status` DISABLE KEYS */;
INSERT INTO `status` (`id_status`,`code`,`title`) VALUES 
 (1,'developing','En Desarrollo'),
 (2,'actively','En Activo'),
 (3,'deactivate','Desactivada'),
 (4,'archived','Archivada');
/*!40000 ALTER TABLE `status` ENABLE KEYS */;


--
-- Definition of table `survey`
--

DROP TABLE IF EXISTS `survey`;
CREATE TABLE `survey` (
  `id_survey` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) NOT NULL,
  `code` varchar(10) NOT NULL,
  `description` varchar(200) NOT NULL,
  `welcomeMessage` mediumtext NOT NULL,
  `endMesagge` mediumtext NOT NULL,
  `json` mediumtext NOT NULL,
  `status_id` int(11) NOT NULL,
  `surveyStartDate` datetime NOT NULL,
  `surveyEndDate` datetime NOT NULL,
  `creationDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `creationUser` varchar(16) NOT NULL,
  `lastUpdateDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `lastUpdateUser` varchar(16) NOT NULL,
  PRIMARY KEY (`id_survey`),
  KEY `fk_survey_status1_idx` (`status_id`),
  CONSTRAINT `fk_survey_status1` FOREIGN KEY (`status_id`) REFERENCES `status` (`id_status`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `survey`
--

/*!40000 ALTER TABLE `survey` DISABLE KEYS */;
INSERT INTO `survey` (`id_survey`,`title`,`code`,`description`,`welcomeMessage`,`endMesagge`,`json`,`status_id`,`surveyStartDate`,`surveyEndDate`,`creationDate`,`creationUser`,`lastUpdateDate`,`lastUpdateUser`) VALUES 
 (1,'Ejemplo de Encuesta','survey_001','Test de funcionamiento','<h3 align=\"center\"><strong>Ejemplo de encuesta</strong><br></h3>','<p>Muchas gracias por participar en esta encuesta.<br></p>','var json = {\r\n    \"completedHtml\": \"<h3>Gracias por sus comentarios. </h3> <h5> ¡Sus sugerencias e ideas nos ayudarán a crear un gran producto! </h5>\",\r\n    \"completedHtmlOnCondition\": [\r\n        {\r\n            \"expression\": \"{nps_score} > 8\",\r\n            \"html\": \"<h3>Gracias por tus comentarios. </h3><h5> Nos alegramos de que te guste nuestro producto. ¡Tus ideas y sugerencias nos ayudarán a hacer que nuestro producto sea aún mejor! </h5>\"\r\n        }, {\r\n            \"expression\": \"{nps_score} < 7\",\r\n            \"html\": \"<h3>Gracias por tus comentarios. </h3><h5>Nos alegra que compartas con nosotros tus ideas. Las sugerencias de nuestros clientes son de vital importancia. Con ellas queremos mejorar el producto y deseamos cumplir con sus expectativas.</h5><br/>\"\r\n        }\r\n    ],\r\n    \"pages\": [\r\n        {\r\n            \"name\": \"page1\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"rating\",\r\n                    \"name\": \"nps_score\",\r\n                    \"title\": \"En una escala de cero a diez, ¿qué tan probable es que recomiende nuestro producto a un amigo o colega?\",\r\n                    \"isRequired\": true,\r\n                    \"rateMin\": 0,\r\n                    \"rateMax\": 10,\r\n                    \"minRateDescription\": \"(Lo más improbable)\",\r\n                    \"maxRateDescription\": \"(Más probable)\"\r\n                }, {\r\n                    \"type\": \"checkbox\",\r\n                    \"name\": \"promoter_features\",\r\n                    \"visibleIf\": \"{nps_score} >= 9\",\r\n                    \"title\": \"¿Qué características valoras más?\",\r\n                    \"isRequired\": true,\r\n                    \"validators\": [\r\n                        {\r\n                            \"type\": \"answercount\",\r\n                            \"text\": \"Por favor, seleccione dos características máximo.\",\r\n                            \"maxCount\": 2\r\n                        }\r\n                    ],\r\n                    \"hasOther\": true,\r\n                    \"choices\": [\r\n                        \"Rendimiento\", \"Estabilidad\", \"Interfaz de usuario\", \"Funcionalidad completa\"\r\n                    ],\r\n                    \"otherText\": \"Otra característica:\",\r\n                    \"colCount\": 2\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"name\": \"passive_experience\",\r\n                    \"visibleIf\": \"{nps_score} > 6  and {nps_score} < 9\",\r\n                    \"title\": \"¿Cuál es la razón principal de su puntaje?\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"name\": \"disappointed_experience\",\r\n                    \"visibleIf\": \"{nps_score} notempty\",\r\n                    \"title\": \"¿Qué extrañas y qué fue decepcionante en tu experiencia con nosotros?\"\r\n                }\r\n            ]\r\n        }\r\n    ],\r\n    \"showQuestionNumbers\": \"off\"\r\n};',2,'2021-12-09 00:00:00','2026-12-30 23:55:55','2021-12-09 18:23:45','admin','2025-05-14 13:59:54','admin'),
 (2,'Satisfaction survey','survey_002','Encuesta de satisfacción','<h3 style=\"text-align: center;\">Satisfaction Survey</h3><p>This is an example copied directly from the examples page of \"<span style=\"font-size: large;\"><strong>survejs.io</strong></span>\". There are many examples, very illustrative and a tool to create and customize all these cases.<br></p>','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n \"pages\": [\r\n  {\r\n   \"name\": \"page1\",\r\n   \"elements\": [\r\n    { \"type\": \"rating\", \"name\": \"satisfaction\", \"title\": \"How satisfied are you with the Product?\", \"mininumRateDescription\": \"Not Satisfied\", \"maximumRateDescription\": \"Completely satisfied\" },\r\n    {\r\n      \"type\": \"panel\",\r\n      \"innerIndent\": 1,\r\n      \"name\": \"panel1\",\r\n      \"title\": \"Please, help us improve our product\",\r\n      \"visibleIf\": \"{satisfaction} < 3\",\r\n      \"elements\": [\r\n        {\r\n          \"type\": \"checkbox\",\r\n          \"choices\": [\r\n            {\r\n              \"value\": \"1\",\r\n              \"text\": \"Customer relationship\"\r\n            },\r\n            {\r\n              \"value\": \"2\",\r\n              \"text\": \"Service quality\"\r\n            },\r\n            {\r\n              \"value\": \"3\",\r\n              \"text\": \"Support response time\"\r\n            }\r\n          ],\r\n          \"name\": \"What should be improved?\"\r\n        },\r\n        {\r\n          \"type\": \"comment\",\r\n          \"name\": \"suggestions\",\r\n          \"title\": \"What would make you more satisfied with the Product?\"\r\n        },\r\n        {\r\n         \"type\": \"panel\", \"innerIndent\": 1, \"name\": \"panel2\", \"title\": \"Send us your contact information (optionally)\", \"state\":  \"collapsed\",\r\n         \"elements\": [\r\n            { \"type\": \"text\",\"name\":  \"name\", \"title\":  \"Name:\" },\r\n            { \"type\": \"text\", \"inputType\": \"email\",\"name\":  \"email\", \"title\":  \"E-mail\"  }\r\n         ]\r\n        }\r\n      ]\r\n    }\r\n   ]\r\n  }\r\n ]\r\n};',2,'2021-12-09 18:47:20','2026-12-30 23:55:55','2021-12-11 18:43:20','admin','2025-05-14 14:00:15','admin'),
 (3,'Matric cell in several columns','survey_003','Matric cell in several columns','<h2 style=\"text-align: center;\">Matric cell in several columns<br></h2>','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    showQuestionNumbers: \"off\",\r\n    questions: [\r\n        {\r\n            type: \"matrixdropdown\",\r\n            name: \"Feelings\",\r\n            title: \"What do your feel?\",\r\n\r\n            columns: [\r\n                {\r\n                    name: \"col1\",\r\n                    cellType: \"radiogroup\",\r\n                    showInMultipleColumns: true,\r\n                    isRequired: true,\r\n                    choices: [\"Strongly disagree\", \"Disagree\", \"Neutral\", \"Agree\", \"Strongly agree\"]\r\n                }, {\r\n                    name: \"comment\",\r\n                    title: \"Please comment\",\r\n                    cellType: \"comment\"\r\n                }\r\n            ],\r\n            rows: [\r\n                \"Excited\",\r\n                \"Enthusiastic\",\r\n                \"Open\",\r\n                \"Physically safe\",\r\n                \"Emotionally safe\",\r\n                \"Apprehensive\",\r\n                \"Nervous\",\r\n                \"Scared\"\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:00:27','admin'),
 (4,'Matrixdynamic/dropdown detail panel','survey_004','Matrixdynamic/dropdown detail panel\r\n','<h2 class=\"examples-page__example-header\" title=\"Matrixdynamic/dropdown detail panel\" style=\"text-align: center;\">Matrixdynamic/dropdown detail panel</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"checkErrorsMode\": \"onValueChanged\",\r\n    \"pages\": [\r\n        {\r\n            \"name\": \"page1\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"matrixdynamic\",\r\n                    \"name\": \"relatives\",\r\n                    \"title\": \"Please enter all blood relatives you know\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"relativeType\",\r\n                            \"title\": \"Relative\",\r\n                            \"cellType\": \"dropdown\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"father\",\r\n                                \"mother\",\r\n                                \"brother\",\r\n                                \"sister\",\r\n                                \"son\",\r\n                                \"daughter\"\r\n                            ]\r\n                        }, {\r\n                            \"name\": \"firstName\",\r\n                            \"title\": \"First name\",\r\n                            \"cellType\": \"text\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"name\": \"lastName\",\r\n                            \"title\": \"Last name\",\r\n                            \"cellType\": \"text\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"detailElements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"name\": \"isalive\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Alive?\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"Yes\", \"No\"\r\n                            ],\r\n                            \"colCount\": 0\r\n                        }, {\r\n                            \"type\": \"dropdown\",\r\n                            \"name\": \"liveage\",\r\n                            \"visibleIf\": \"{row.isalive} = \'Yes\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Age\",\r\n                            \"isRequired\": true,\r\n                            \"choicesMin\": 1,\r\n                            \"choicesMax\": 115\r\n                        }, {\r\n                            \"type\": \"dropdown\",\r\n                            \"name\": \"deceasedage\",\r\n                            \"visibleIf\": \"{row.isalive} = \'No\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Deceased Age\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": -1,\r\n                                    \"text\": \"Unknown\"\r\n                                }\r\n                            ],\r\n                            \"choicesMin\": 1,\r\n                            \"choicesMax\": 115\r\n                        }, {\r\n                            \"type\": \"radiogroup\",\r\n                            \"name\": \"causeofdeathknown\",\r\n                            \"visibleIf\": \"{row.isalive} = \'No\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Cause of Death Known?\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"Yes\", \"No\"\r\n                            ],\r\n                            \"colCount\": 0\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"causeofdeath\",\r\n                            \"visibleIf\": \"{row.isalive} = \'No\' and {row.causeofdeathknown} = \'Yes\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Cause of Death\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"detailPanelMode\": \"underRow\",\r\n                    \"rowCount\": 1,\r\n                    \"addRowText\": \"Add a blood relative\",\r\n                    \"removeRowText\": \"Remove the relative\"\r\n                }\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:00:39','admin'),
 (5,'Start With New Line','survey_005','Start With New Line\r\n','<h2 class=\"examples-page__example-header\" title=\"Start With New Line\" style=\"text-align: center;\">Start With New Line</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    questionTitleLocation: \"bottom\",\r\n    showQuestionNumbers: \"off\",\r\n    pages: [\r\n        {\r\n            name: \"Address\",\r\n            title: \"Address\",\r\n            questions: [\r\n                {\r\n                    type: \"text\",\r\n                    name: \"address1\",\r\n                    title: \"Street Address\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"address2\",\r\n                    title: \"Address Line 2\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"city\",\r\n                    title: \"City\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"state\",\r\n                    startWithNewLine: false,\r\n                    title: \"State / Province / Region\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"zip\",\r\n                    title: \"Zip / Postal Code\"\r\n                }, {\r\n                    type: \"dropdown\",\r\n                    name: \"country\",\r\n                    startWithNewLine: false,\r\n                    title: \"Country\",\r\n                    choicesByUrl: {\r\n                        url: \"https://surveyjs.io/api/CountriesExample\",\r\n                        valueName: \"name\"\r\n                    }\r\n                }\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:00:56','admin'),
 (6,'Quiz','survey_006','Quiz\r\n\r\n','<h2 class=\"examples-page__example-header\" title=\"Quiz\" style=\"text-align: center;\">Quiz</h2>\r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    title: \"American History\",\r\n    showProgressBar: \"bottom\",\r\n    showTimerPanel: \"top\",\r\n    maxTimeToFinishPage: 10,\r\n    maxTimeToFinish: 25,\r\n    firstPageIsStarted: true,\r\n    startSurveyText: \"Start Quiz\",\r\n    pages: [\r\n        {\r\n            questions: [\r\n                {\r\n                    type: \"html\",\r\n                    html: \"You are about to start quiz by history. <br/>You have 10 seconds for every page and 25 seconds for the whole survey of 3 questions.<br/>Please click on <b>\'Start Quiz\'</b> button when you are ready.\"\r\n                }\r\n            ]\r\n        }, {\r\n            questions: [\r\n                {\r\n                    type: \"radiogroup\",\r\n                    name: \"civilwar\",\r\n                    title: \"When was the Civil War?\",\r\n                    choices: [\r\n                        \"1750-1800\", \"1800-1850\", \"1850-1900\", \"1900-1950\", \"after 1950\"\r\n                    ],\r\n                    correctAnswer: \"1850-1900\"\r\n                }\r\n            ]\r\n        }, {\r\n            questions: [\r\n                {\r\n                    type: \"radiogroup\",\r\n                    name: \"libertyordeath\",\r\n                    title: \"Who said \'Give me liberty or give me death?\'\",\r\n                    choicesOrder: \"random\",\r\n                    choices: [\r\n                        \"John Hancock\", \"James Madison\", \"Patrick Henry\", \"Samuel Adams\"\r\n                    ],\r\n                    correctAnswer: \"Patrick Henry\"\r\n                }\r\n            ]\r\n        }, {\r\n            maxTimeToFinish: 15,\r\n            questions: [\r\n                {\r\n                    type: \"radiogroup\",\r\n                    name: \"magnacarta\",\r\n                    title: \"What is the Magna Carta?\",\r\n                    choicesOrder: \"random\",\r\n                    choices: [\r\n                        \"The foundation of the British parliamentary system\", \"The Great Seal of the monarchs of England\", \"The French Declaration of the Rights of Man\", \"The charter signed by the Pilgrims on the Mayflower\"\r\n                    ],\r\n                    correctAnswer: \"The foundation of the British parliamentary system\"\r\n                }\r\n            ]\r\n        }\r\n    ],\r\n    completedHtml: \"<h4>You have answered correctly <b>{correctedAnswers}</b> questions from <b>{questionCount}</b>.</h4>\"\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:01:17','admin'),
 (7,'Survey Data','survey_007','Survey Data','<h2 class=\"examples-page__example-header\" title=\"Survey Data\" style=\"text-align: center;\">Survey Data</h2>\r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"pages\": [\r\n        {\r\n            \"name\": \"page1\",\r\n            \"title\": \"Who are you employed by?\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"matrixdynamic\",\r\n                    \"minRowCount\": 1,\r\n                    \"rowCount\": 1,\r\n                    \"name\": \"employer_names\",\r\n                    \"valueName\": \"employers\",\r\n                    \"isRequired\": true,\r\n                    \"title\": \"Please enter all your employers\",\r\n                    \"addRowText\": \"Add another employer\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"name\",\r\n                            \"isRequired\": true,\r\n                            \"title\": \"Name of employer\",\r\n                            \"cellType\": \"text\"\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        }, {\r\n            \"name\": \"page2\",\r\n            \"title\": \"Tells us about your employer(s)\",\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"paneldynamic\",\r\n                    \"renderMode\": \"list\",\r\n                    \"allowAddPanel\": false,\r\n                    \"allowRemovePanel\": false,\r\n                    \"name\": \"arrray_employer_info\",\r\n                    \"title\": \"Your employers\",\r\n                    \"valueName\": \"employers\",\r\n                    \"templateTitle\": \"Employer name: {panel.name}\",\r\n                    \"templateElements\": [\r\n                        {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_mployer_address\",\r\n                            \"title\": \"Address\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"employer_address\",\r\n                                    \"valueName\": \"address\",\r\n                                    \"title\": \"Address\"\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"employer_phone\",\r\n                                    \"valueName\": \"phone\",\r\n                                    \"title\": \"Phone number:\"\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"employer_abn\",\r\n                                    \"valueName\": \"abn\",\r\n                                    \"title\": \"ABN\"\r\n                                }\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_employer_role\",\r\n                            \"title\": \"What is your role?\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"Full time\", \"Part time\", \"Casual\", \"Seasonal\"\r\n                                    ],\r\n                                    \"name\": \"employer_role\",\r\n                                    \"title\": \"Your role\",\r\n                                    \"valueName\": \"role\"\r\n                                }\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_employer_hours_work\",\r\n                            \"title\": \"What hours do you work?\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"inputType\": \"number\",\r\n                                    \"name\": \"member_hours_worked\",\r\n                                    \"valueName\": \"hours_worked\",\r\n                                    \"title\": \"Hours:\"\r\n                                }, {\r\n                                    \"type\": \"dropdown\",\r\n                                    \"name\": \"member_hours_worked_frequency\",\r\n                                    \"title\": \"Worked Frequency:\",\r\n                                    \"valueName\": \"hours_worked_frequency\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"defaultValue\": \"Year\",\r\n                                    \"choices\": [\"Day\", \"Week\", \"Fortnight\", \"Month\", \"Year\"]\r\n                                }\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panel_employer_income\",\r\n                            \"title\": \"What income do you receive?\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"inputType\": \"number\",\r\n                                    \"name\": \"employer_income\",\r\n                                    \"valueName\": \"income\",\r\n                                    \"title\": \"Income:\"\r\n                                }, {\r\n                                    \"type\": \"dropdown\",\r\n                                    \"name\": \"employer_income_frequency\",\r\n                                    \"title\": \"Income Frequency\",\r\n                                    \"valueName\": \"income_frequency\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"defaultValue\": \"Year\",\r\n                                    \"choices\": [\"Day\", \"Week\", \"Fortnight\", \"Month\", \"Year\"]\r\n                                }\r\n                            ]\r\n                        }\r\n                    ]\r\n                }\r\n            ]\r\n        }\r\n    ],\r\n    \"showQuestionNumbers\": \"off\"\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:01:31','admin'),
 (8,'Custom Render of Survey Elements','survey_008','Custom Render of Survey Elements','<h2 class=\"examples-page__example-header\" title=\"Custom Render of Survey Elements\" style=\"text-align: center;\">Custom Render of Survey Elements</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','//Add a custom \'popupdescription\' property to questions of all types and to pages\r\nSurvey\r\n    .Serializer\r\n    .addProperty(\"question\", \"popupdescription:text\");\r\nSurvey\r\n    .Serializer\r\n    .addProperty(\"page\", \"popupdescription:text\");\r\nfunction showDescription(element) {\r\n    document\r\n        .getElementById(\"questionDescriptionText\")\r\n        .innerHTML = element.popupdescription;\r\n    $(\"#questionDescriptionPopup\").modal();\r\n}\r\n\r\nvar json = {\r\n    title: \"Software developer survey.\",\r\n    pages: [\r\n        {\r\n            title: \"What operating system do you use?\",\r\n            popupdescription: \"Select the operating system you are currently using.\",\r\n            questions: [\r\n                {\r\n                    type: \"checkbox\",\r\n                    name: \"opSystem\",\r\n                    title: \"OS\",\r\n                    hasOther: true,\r\n                    isRequired: true,\r\n                    popupdescription: \"If you do not use any of the listed operating system, please select \'others\' and type your operating system name.\",\r\n                    choices: [\"Windows\", \"Linux\", \"Macintosh OSX\"]\r\n                }\r\n            ]\r\n        }, {\r\n            title: \"What language(s) are you currently using?\",\r\n            popupdescription: \"Select all programming languages you have been using for the last six months.\",\r\n            questions: [\r\n                {\r\n                    type: \"checkbox\",\r\n                    name: \"langs\",\r\n                    title: \"Please select from the list\",\r\n                    popupdescription: \"Select all programming languages you have been using for the last six months.\",\r\n                    colCount: 4,\r\n                    isRequired: true,\r\n                    choices: [\r\n                        \"Javascript\",\r\n                        \"Java\",\r\n                        \"Python\",\r\n                        \"CSS\",\r\n                        \"PHP\",\r\n                        \"Ruby\",\r\n                        \"C++\",\r\n                        \"C\",\r\n                        \"Shell\",\r\n                        \"C#\",\r\n                        \"Objective-C\",\r\n                        \"R\",\r\n                        \"VimL\",\r\n                        \"Go\",\r\n                        \"Perl\",\r\n                        \"CoffeeScript\",\r\n                        \"TeX\",\r\n                        \"Swift\",\r\n                        \"Scala\",\r\n                        \"Emacs Lisp\",\r\n                        \"Haskell\",\r\n                        \"Lua\",\r\n                        \"Clojure\",\r\n                        \"Matlab\",\r\n                        \"Arduino\",\r\n                        \"Makefile\",\r\n                        \"Groovy\",\r\n                        \"Puppet\",\r\n                        \"Rust\",\r\n                        \"PowerShell\"\r\n                    ]\r\n                }\r\n            ]\r\n        }, {\r\n            title: \"Please enter your name and e-mail\",\r\n            popupdescription: \"We will not share this information with any third-party organization.\",\r\n            questions: [\r\n                {\r\n                    type: \"text\",\r\n                    name: \"name\",\r\n                    title: \"Name:\",\r\n                    popupdescription: \"Please, type your name as \'Given Name\' \'Family Name\'.\"\r\n                }, {\r\n                    type: \"text\",\r\n                    name: \"email\",\r\n                    title: \"Your e-mail\",\r\n                    popupdescription: \"Please, make sure you do not misspell your e-mail.\"\r\n                }\r\n            ]\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:01:43','admin'),
 (9,'Datepicker','survey_009','Datepicker\r\n\r\n','<h2 class=\"examples-page__example-header\" title=\"Bootstrap Datepicker\" style=\"text-align: center;\">Datepicker</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"elements\": [\r\n        {\r\n            \"name\": \"date\",\r\n            \"type\": \"datepicker\",\r\n            \"inputType\": \"date\",\r\n            \"title\": \"Your favorite date:\",\r\n            \"dateFormat\": \"mm/dd/yy\",\r\n            \"isRequired\": true\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:01:54','admin'),
 (11,'Widget for masking inputs','survey_010','Widget for masking inputs\r\n\r\n','<h3 class=\"title title--tiny examples-page__example-description\" style=\"text-align: center;\">Widget for masking inputs</h3>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"elements\": [\r\n        {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"datetime\",\r\n            \"inputFormat\": \"dd/mm/yyyy\",\r\n            \"name\": \"date1\",\r\n            \"title\": \"Date:\"\r\n        }, {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"datetime\",\r\n            \"inputFormat\": \"mm/dd/yyyy\",\r\n            \"name\": \"date2\",\r\n            \"title\": \"Date:\"\r\n        }, {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"currency\",\r\n            \"name\": \"currency\",\r\n            \"title\": \"Currency:\"\r\n        }, {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"decimal\",\r\n            \"name\": \"decimal\",\r\n            \"title\": \"Decimal:\"\r\n        }, {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"phone\",\r\n            \"inputFormat\": \"+#(###)-###-####\",\r\n            \"name\": \"phone\",\r\n            \"title\": \"Phone:\"\r\n        }, {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"ip\",\r\n            \"name\": \"ip\",\r\n            \"title\": \"IP address:\"\r\n        }, {\r\n            \"type\": \"text\",\r\n            \"inputMask\": \"email\",\r\n            \"name\": \"email\",\r\n            \"title\": \"Email address:\"\r\n        }\r\n    ]\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:02:08','admin'),
 (12,'Patient Medical History','survey_011','Patient Medical History\r\n\r\n\r\n','<h2 class=\"examples-page__example-header\" title=\"Patient Medical History\" style=\"text-align: center;\">Patient Medical History</h2>\r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                    \r\n                            \r\n                                \r\n                                                    \r\n                                \r\n                                    \r\n                                \r\n                            \r\n                            \r\n                                                    \r\n                                \r\n                                    ','<p>Thank you for participating in this survey.<br></p>','var json = {\r\n    \"pages\": [\r\n        {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"patienName\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"patientLastName\",\r\n                            \"title\": \"(Last)\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"patienFirstName\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"(First)\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"patientMiddleName\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"(M.I)\"\r\n                        }\r\n                    ],\r\n                    \"questionTitleLocation\": \"bottom\",\r\n                    \"title\": \"Patient Name\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"panel2\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"socialsecurity\",\r\n                            \"title\": \"Social Security #:\",\r\n                            \"isRequired\": true,\r\n                            \"inputFormat\": \"999-99-9999\"\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"inputType\": \"date\",\r\n                            \"isRequired\": true,\r\n                            \"name\": \"birthDate\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Date of birth:\"\r\n                        }, {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": \"male\",\r\n                                    \"text\": \"Male\"\r\n                                }, {\r\n                                    \"value\": \"female\",\r\n                                    \"text\": \"Female\"\r\n                                }\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"sex\",\r\n                            \"title\": \"Sex:\"\r\n                        }\r\n                    ],\r\n                    \"questionTitleLocation\": \"left\",\r\n                    \"title\": \"Social Security & Birth Date\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"panel1\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": \"patient\",\r\n                                    \"text\": \"Patient\"\r\n                                }, {\r\n                                    \"value\": \"spouse\",\r\n                                    \"text\": \"Spouse\"\r\n                                }\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"hasOther\": true,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"completedBy\",\r\n                            \"otherText\": \"Other (specify)\",\r\n                            \"title\": \"Who completed this form:\"\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"completedByOtherName\",\r\n                            \"visibleIf\": \"{completedBy} != \\\"patient\\\"\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Name (if other than patient):\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"title\": \"Completed By\"\r\n                }\r\n            ],\r\n            \"name\": \"introduction\",\r\n            \"title\": \"Introduction\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        {\r\n                            \"value\": \"no\",\r\n                            \"text\": \"No\"\r\n                        }, {\r\n                            \"value\": \"yes\",\r\n                            \"text\": \"Yes\"\r\n                        }\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"everhospitalized\",\r\n                    \"title\": \"Have you ever been hospitalized?\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        {\r\n                            \"value\": \"no\",\r\n                            \"text\": \"No\"\r\n                        }, {\r\n                            \"value\": \"yes\",\r\n                            \"text\": \"Yes\"\r\n                        }\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"injuriesbrokenbones\",\r\n                    \"title\": \"Have you had any serious injuries and/or broken bones?\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"isRequired\": true,\r\n                    \"name\": \"injuriesbrokenbones_describe\",\r\n                    \"startWithNewLine\": false,\r\n                    \"title\": \"Describe\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{injuriesbrokenbones} = \\\"yes\\\"\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        {\r\n                            \"value\": \"unknown\",\r\n                            \"text\": \"Unknown\"\r\n                        }, {\r\n                            \"value\": \"no\",\r\n                            \"text\": \"No\"\r\n                        }, {\r\n                            \"value\": \"yes\",\r\n                            \"text\": \"Yes\"\r\n                        }\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"bloodtransfusion\",\r\n                    \"title\": \"Have you ever received a blood transfusion?\"\r\n                }, {\r\n                    \"type\": \"text\",\r\n                    \"name\": \"bloodtransfusion_years\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{bloodtransfusion}=\\\"yes\\\"\",\r\n                    \"startWithNewLine\": false,\r\n                    \"title\": \"Approximate year(s)\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        {\r\n                            \"value\": \"no\",\r\n                            \"text\": \"No\"\r\n                        }, {\r\n                            \"value\": \"yes\",\r\n                            \"text\": \"Yes\"\r\n                        }\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"ousideUSACanada\",\r\n                    \"title\": \"Have you ever traveled or lived outside the United States or Canada?\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"isRequired\": true,\r\n                    \"name\": \"ousideUSACanada_describe\",\r\n                    \"startWithNewLine\": false,\r\n                    \"title\": \"Describe\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{ousideUSACanada} = \\\"yes\\\"\"\r\n                }, {\r\n                    \"type\": \"matrixdropdown\",\r\n                    \"name\": \"immunizations\",\r\n                    \"title\": \"Have you received the following IMMUNIZATIONS?  If yes, indicate the approximate year it was last given:\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"answer\",\r\n                            \"title\": \"Please select\",\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": \"unknown\",\r\n                                    \"text\": \"Unknown\"\r\n                                }, {\r\n                                    \"value\": \"no\",\r\n                                    \"text\": \"No\"\r\n                                }, {\r\n                                    \"value\": \"yes\",\r\n                                    \"text\": \"Yes\"\r\n                                }\r\n                            ],\r\n                            \"cellType\": \"radiogroup\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"name\": \"year\",\r\n                            \"title\": \"Year\",\r\n                            \"cellType\": \"text\",\r\n                            \"isRequired\": true,\r\n                            \"visibleIf\": \"{row.answer} = \\\"yes\\\"\"\r\n                        }\r\n                    ],\r\n                    \"choices\": [\r\n                        1, 2, 3, 4, 5\r\n                    ],\r\n                    \"rows\": [\r\n                        \"Pneumococcal (for pneumonia)\",\r\n                        \"Hepatitis A\",\r\n                        \"Hepatitis B\",\r\n                        \"Tetanus/Diphtheria within last 10 years\",\r\n                        \"Influenza (flu)\",\r\n                        \"Measles\",\r\n                        \"Mumps\",\r\n                        \"Rubella\",\r\n                        \"Polio\"\r\n                    ]\r\n                }, {\r\n                    \"type\": \"matrixdynamic\",\r\n                    \"name\": \"problems1\",\r\n                    \"title\": \"Have you ever had any of the following?\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"problem\",\r\n                            \"title\": \"Problem\",\r\n                            \"choices\": [\r\n                                \"Abnormal chest x-ray\",\r\n                                \"Anesthesia complications\",\r\n                                \"Anxiety, depression or mental illness\",\r\n                                \"Blood problems (abnormal bleeding, anemia, high or low white count)\",\r\n                                \"Diabetes\",\r\n                                \"Growth removed from the colon or rectum (polyp or tumor)\",\r\n                                \"High blood pressure\",\r\n                                \"High cholesterol or triglycerides\",\r\n                                \"Sexually transmitted disease\",\r\n                                \"Stroke or TIA\",\r\n                                \"Treatment for alcohol and/or drug abuse\",\r\n                                \"Tuberculosis or positive tuberculin skin test\",\r\n                                \"Cosmetic or plastic surgery\"\r\n                            ]\r\n                        }, {\r\n                            \"name\": \"answer\",\r\n                            \"title\": \"Please answer\",\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": \"no\",\r\n                                    \"text\": \"No\"\r\n                                }, {\r\n                                    \"value\": \"yes\",\r\n                                    \"text\": \"Yes\"\r\n                                }\r\n                            ],\r\n                            \"cellType\": \"radiogroup\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"name\": \"description\",\r\n                            \"title\": \"Describe the problem\",\r\n                            \"cellType\": \"comment\",\r\n                            \"isRequired\": true,\r\n                            \"visibleIf\": \"{row.answer} = \\\"yes\\\"\"\r\n                        }\r\n                    ],\r\n                    \"choices\": [\r\n                        1, 2, 3, 4, 5\r\n                    ],\r\n                    \"rowCount\": 1\r\n                }, {\r\n                    \"type\": \"matrixdynamic\",\r\n                    \"name\": \"problems2\",\r\n                    \"title\": \"Indicate whether you have ever had a medical problem and/or surgery related to each of the following\",\r\n                    \"columns\": [\r\n                        {\r\n                            \"name\": \"problem\",\r\n                            \"title\": \"Problem\",\r\n                            \"choices\": [\r\n                                \"Eyes (cataracts, glaucoma)\",\r\n                                \"Ears, nose, sinuses, or tonsils\",\r\n                                \"Thyroid or parathyroid glands\",\r\n                                \"Heart valves or abnormal heart rhythm\",\r\n                                \"Coronary (heart) arteries (angina)\",\r\n                                \"Arteries (aorta, arteries to head, arms, legs) \",\r\n                                \"Veins or blood clots in the veins\",\r\n                                \"Lungs\",\r\n                                \"Esophagus or stomach (ulcer)\",\r\n                                \"Bowel (small & large intestine)\",\r\n                                \"Appendix\",\r\n                                \"Liver or gallbladder (including hepatitis)\",\r\n                                \"Hernia\",\r\n                                \"Kidneys or bladder\",\r\n                                \"Bones, joints or muscles\",\r\n                                \"Back, neck or spine\",\r\n                                \"Brain\",\r\n                                \"Skin\",\r\n                                \"Breasts\",\r\n                                \"Females: uterus, tubes, ovaries\",\r\n                                \"Males: prostate, penis, testes, vasectomy\",\r\n                                \"Other: Describe\"\r\n                            ],\r\n                            \"cellType\": \"dropdown\",\r\n                            \"isRequired\": true,\r\n                            \"choicesOrder\": \"asc\"\r\n                        }, {\r\n                            \"name\": \"type\",\r\n                            \"title\": \"Type\",\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": \"medical\",\r\n                                    \"text\": \"Medical Problem\"\r\n                                }, {\r\n                                    \"value\": \"surgery\",\r\n                                    \"text\": \"Surgery\"\r\n                                }\r\n                            ],\r\n                            \"cellType\": \"checkbox\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"name\": \"year\",\r\n                            \"title\": \"Year(s) of Surgery\",\r\n                            \"cellType\": \"text\",\r\n                            \"isRequired\": true,\r\n                            \"visibleIf\": \"{row.type} contains \\\"surgery\\\"\"\r\n                        }, {\r\n                            \"name\": \"describe\",\r\n                            \"title\": \"Describe\",\r\n                            \"cellType\": \"comment\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"choices\": [\r\n                        1, 2, 3, 4, 5\r\n                    ],\r\n                    \"rowCount\": 1,\r\n                    \"addRowText\": \"Add Problem\"\r\n                }\r\n            ],\r\n            \"name\": \"medicalHistory\",\r\n            \"questionTitleLocation\": \"left\",\r\n            \"title\": \"Past Medical History\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"education\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"dropdown\",\r\n                            \"name\": \"schoolYearsCompleted\",\r\n                            \"title\": \"How many yeas of school have you completed?\",\r\n                            \"isRequired\": true,\r\n                            \"choicesMin\": 0,\r\n                            \"choicesMax\": 12\r\n                        }\r\n                    ],\r\n                    \"title\": \"Education\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"occupations\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"Retired\", \"Unemployed\", \"Homemaker\", \"Employed\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"employmentStatus\",\r\n                            \"title\": \"Your current employment status:\"\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"currentOcupation\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{employmentStatus} = \'Employed\'\",\r\n                            \"title\": \"Current Ocupation(s):\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"comment\",\r\n                            \"name\": \"previousOccupations\",\r\n                            \"title\": \"Previous Occupations/Jobs:\"\r\n                        }\r\n                    ],\r\n                    \"title\": \"Occupations\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"disability\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"disabled\",\r\n                            \"title\": \"Are you disabled?\"\r\n                        }, {\r\n                            \"type\": \"comment\",\r\n                            \"name\": \"disableInfo\",\r\n                            \"title\": \"Info:\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{disabled} = \'Yes\'\"\r\n                        }\r\n                    ],\r\n                    \"title\": \"Disability\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"abuse\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"abused\",\r\n                            \"title\": \"Have you even been physically, sexually, or emotionally abused?\"\r\n                        }, {\r\n                            \"type\": \"comment\",\r\n                            \"name\": \"abusedInfo\",\r\n                            \"title\": \"Info:\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{abused} = \'Yes\'\"\r\n                        }, {\r\n                            \"type\": \"matrixdropdown\",\r\n                            \"name\": \"subsctancesUsing\",\r\n                            \"title\": \"Have you used any of the following substances?\",\r\n                            \"columns\": [\r\n                                {\r\n                                    \"name\": \"current\",\r\n                                    \"title\": \"Currently Use?\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"cellType\": \"radiogroup\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"previous\",\r\n                                    \"title\": \"Previously Used?\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"cellType\": \"radiogroup\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"amount\",\r\n                                    \"title\": \"Type/Amount/Frequancy\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true,\r\n                                    \"visibleIf\": \"{row.current} = \'Yes\' or {row.previous} = \'Yes\'\"\r\n                                }, {\r\n                                    \"name\": \"long\",\r\n                                    \"title\": \"How Long? (Years)\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true,\r\n                                    \"visibleIf\": \"{row.current} = \'Yes\' or {row.previous} = \'Yes\'\"\r\n                                }, {\r\n                                    \"name\": \"stopped\",\r\n                                    \"title\": \"When stopped? (Year)\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true,\r\n                                    \"visibleIf\": \"{row.previous} = \'Yes\'\"\r\n                                }\r\n                            ],\r\n                            \"choices\": [\r\n                                1, 2, 3, 4, 5\r\n                            ],\r\n                            \"rows\": [\"Caffeine: coffee, tea, soda\", \"Tobacco\", \"Alcohol - bear, wine, liquor\", \"Recreational/Street drugs\"]\r\n                        }\r\n                    ],\r\n                    \"title\": \"Abuse\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"maritalStatus\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"currentlyMarried\",\r\n                            \"title\": \"Are you currently married?\"\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"currentMarriageYear\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{currentlyMarried} = \'Yes\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"In what year did this marriage occure?\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"paneldynamic\",\r\n                            \"name\": \"previousMarriages\",\r\n                            \"title\": \"List all previous marriages\",\r\n                            \"templateElements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"previousMarriageYear\",\r\n                                    \"title\": \"Year married:\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"previousMarriageDuration\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"title\": \"Duration (in Years):\",\r\n                                    \"isRequired\": true\r\n                                }\r\n                            ],\r\n                            \"panelCount\": 1,\r\n                            \"panelAddText\": \"Add marriage\"\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"currentSpouse\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"Not applicable\", \"Alive\", \"Deceased\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"currentSpouseStatus\",\r\n                                    \"title\": \" \"\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"currentSpouseAge\",\r\n                                    \"visible\": false,\r\n                                    \"visibleIf\": \"{currentSpouseStatus} = \'Alive\'\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"title\": \"Age\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"type\": \"comment\",\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"currentSpouseHelthProblems\",\r\n                                    \"rows\": 2,\r\n                                    \"title\": \"Health problems or cause of death:\",\r\n                                    \"visibleIf\": \"{currentSpouseStatus} != \'Not applicable\' \"\r\n                                }, {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"Retired\", \"Unemployed\", \"Homemaker\", \"Employed\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"currentSpouseEmploymentStatus\",\r\n                                    \"title\": \"Current employment status:\",\r\n                                    \"visible\": false,\r\n                                    \"visibleIf\": \"{currentSpouseStatus} = \'Alive\'\"\r\n                                }\r\n                            ],\r\n                            \"title\": \"Current Spouse Information\"\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"currentSpouseOccupation\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{currentSpouseEmploymentStatus} = \'Employed\'\",\r\n                            \"title\": \"Current occupation(s):\",\r\n                            \"isRequired\": true\r\n                        }\r\n                    ],\r\n                    \"title\": \"Marital Status\"\r\n                }\r\n            ],\r\n            \"name\": \"socialHistory\",\r\n            \"questionTitleLocation\": \"left\",\r\n            \"title\": \"Social History\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"Yes\", \"No\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"adopted\",\r\n                    \"title\": \"Are you adopted?\"\r\n                }, {\r\n                    \"type\": \"html\",\r\n                    \"name\": \"adoptedInfo\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{adopted} = \'Yes\'\",\r\n                    \"html\": \"If known, complete the following information about your <b>blood</b> relatives (include children).  Exclude adoptive parents, siblings and   adopted children.\"\r\n                }, {\r\n                    \"type\": \"html\",\r\n                    \"name\": \"nonAdoptedInfo\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{adopted} = \'No\'\",\r\n                    \"html\": \"Complete the following information about your <b>blood</b> relatives.  Exclude adoptive siblings and adopted children. \"\r\n                }, {\r\n                    \"type\": \"paneldynamic\",\r\n                    \"name\": \"bloodRelativesInfo\",\r\n                    \"title\": \"Blood relatives information\",\r\n                    \"templateElements\": [\r\n                        {\r\n                            \"type\": \"dropdown\",\r\n                            \"name\": \"relativeType\",\r\n                            \"title\": \"Blood Relative:\",\r\n                            \"isRequired\": true,\r\n                            \"choices\": [\r\n                                \"Father\",\r\n                                \"Mother\",\r\n                                \"Brother\",\r\n                                \"Sister\",\r\n                                \"Son\",\r\n                                \"Daughter\"\r\n                            ]\r\n                        }, {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"Alive\", \"Deceased\", \"Unknown\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"relativeStatus\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Is he/she:\"\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"relativeAge\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{panel.relativeStatus} = \'Alive\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Current age:\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"relativeAgeOfDeath\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{panel.relativeStatus} = \'Deceased\'\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Age of death:\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"relativeDeathInfo\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"Known\", \"Unknown\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"relativeCauseOfDeath\",\r\n                                    \"title\": \"Cause of death:\"\r\n                                }, {\r\n                                    \"type\": \"comment\",\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"relativeCauseOfDeathDescription\",\r\n                                    \"title\": \"Description:\",\r\n                                    \"visible\": false,\r\n                                    \"visibleIf\": \"{panel.relativeCauseOfDeath} = \'Known\'\"\r\n                                }\r\n                            ],\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{panel.relativeStatus} = \'Deceased\'\"\r\n                        }, {\r\n                            \"type\": \"matrixdynamic\",\r\n                            \"name\": \"relativeCondition\",\r\n                            \"title\": \"Describe the illness or conditios\",\r\n                            \"columns\": [\r\n                                {\r\n                                    \"name\": \"name\",\r\n                                    \"title\": \"Illness/Condition\",\r\n                                    \"choices\": [\r\n                                        \"Cancer\",\r\n                                        \"Heart Disease\",\r\n                                        \"Diabetes\",\r\n                                        \"Stroke/TIA\",\r\n                                        \"High Blood Pressure\",\r\n                                        \"High Cholesterol or Triglycerides\",\r\n                                        \"Liver Disease\",\r\n                                        \"Alcohol or Drug Abuse\",\r\n                                        \"Anxiety, Depression or Psychiatric Illness\",\r\n                                        \"Tuberculosis\",\r\n                                        \"Anesthesia Complications\",\r\n                                        \"Genetic Disorder\",\r\n                                        \"Other\"\r\n                                    ],\r\n                                    \"cellType\": \"dropdown\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"description\",\r\n                                    \"title\": \"Describe\",\r\n                                    \"cellType\": \"comment\",\r\n                                    \"isRequired\": true\r\n                                }\r\n                            ],\r\n                            \"choices\": [\r\n                                1, 2, 3, 4, 5\r\n                            ],\r\n                            \"rowCount\": 1,\r\n                            \"addRowText\": \"Add illness\"\r\n                        }\r\n                    ],\r\n                    \"panelCount\": 1,\r\n                    \"panelAddText\": \"Add Family Member\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"name\": \"relativesAdditionalInfo\",\r\n                    \"title\": \"Other information about your family which you want us to know: \"\r\n                }\r\n            ],\r\n            \"name\": \"familyHistory\",\r\n            \"questionTitleLocation\": \"left\",\r\n            \"title\": \"Family History\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"primaryCareProvider\",\r\n                    \"title\": \"Do you have a Primary Care Provider?\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"primaryCareProviderInfo\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"primaryCareProviderName\",\r\n                            \"title\": \"Name:\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"text\",\r\n                            \"name\": \"primaryCareProviderPhone\",\r\n                            \"startWithNewLine\": false,\r\n                            \"title\": \"Phone:\",\r\n                            \"isRequired\": true\r\n                        }, {\r\n                            \"type\": \"comment\",\r\n                            \"name\": \"primaryCareProviderAddress\",\r\n                            \"title\": \"Address:\"\r\n                        }, {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"primaryCareProviderSent\",\r\n                            \"title\": \"Do you want a summary of your visit sent to this person?\"\r\n                        }\r\n                    ],\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{primaryCareProvider} = \'Yes\'\",\r\n                    \"title\": \"Primary Care Provider\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"primaryCareProviderRecommend\",\r\n                    \"title\": \"Did a non-Vanderbilt physician or healthcare provider recommend or arrange this visit for you?\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"primaryCareProviderRecommendInfo\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                {\r\n                                    \"value\": \"primary\",\r\n                                    \"text\": \"Your Primary Care Provider (as listed above) \"\r\n                                }, {\r\n                                    \"value\": \"other\",\r\n                                    \"text\": \"Other physician or healthcare provider\"\r\n                                }\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"primaryCareProviderWhoSent\",\r\n                            \"title\": \"Who sent you?\"\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"primaryCareProviderOtherInfo\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"primaryCareProviderOtherName\",\r\n                                    \"title\": \"Name:\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"primaryCareProviderOtherPhone\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"title\": \"Phone:\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"type\": \"comment\",\r\n                                    \"name\": \"primaryCareProviderOtherAddress\",\r\n                                    \"title\": \"Address:\"\r\n                                }, {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"primaryCareProviderOtherSent\",\r\n                                    \"title\": \"Do you want a summary of your visit sent to this person?\"\r\n                                }\r\n                            ],\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{primaryCareProviderWhoSent} = \'other\'\",\r\n                            \"title\": \"Other physician or healthcare provider\"\r\n                        }\r\n                    ],\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{primaryCareProviderRecommend} = \'Yes\'\"\r\n                }\r\n            ],\r\n            \"name\": \"healthcareProvider\",\r\n            \"questionTitleLocation\": \"left\",\r\n            \"title\": \"Healthcare Provider Information\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"currentUsingMedication\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"currentMedication\",\r\n                            \"title\": \"Are you currently taking any prescription and/or non-prescription medications including vitamins, nutritional supplements, oral contraceptives, pain relievers, diuretics, laxatives, herbal remedies, and cold medications? \"\r\n                        }, {\r\n                            \"type\": \"matrixdynamic\",\r\n                            \"name\": \"currentMedicationList\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{currentMedication} = \'Yes\'\",\r\n                            \"title\": \"Medication list\",\r\n                            \"description\": \"Please add all medication you are currently taking\",\r\n                            \"columns\": [\r\n                                {\r\n                                    \"name\": \"name\",\r\n                                    \"title\": \"Name of Medication\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"dose\",\r\n                                    \"title\": \"Dose\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"often\",\r\n                                    \"title\": \"How Often Taken\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }\r\n                            ],\r\n                            \"choices\": [\r\n                                1, 2, 3, 4, 5\r\n                            ],\r\n                            \"rowCount\": 1,\r\n                            \"addRowText\": \"Add medication\"\r\n                        }\r\n                    ],\r\n                    \"title\": \"Medications currently using\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"recentlyUsedMedication\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"recentlyUsedMedication\",\r\n                            \"title\": \"Are there other medications you have recently used?\"\r\n                        }, {\r\n                            \"type\": \"matrixdynamic\",\r\n                            \"name\": \"recentlyUsedMedicationList\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{recentlyUsedMedication} = \'Yes\'\",\r\n                            \"title\": \"Medication list\",\r\n                            \"description\": \"Please add all medication you have recently used\",\r\n                            \"columns\": [\r\n                                {\r\n                                    \"name\": \"name\",\r\n                                    \"title\": \"Name of Medication\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"dose\",\r\n                                    \"title\": \"Dose\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"often\",\r\n                                    \"title\": \"How Often Taken\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }\r\n                            ],\r\n                            \"choices\": [\r\n                                1, 2, 3, 4, 5\r\n                            ],\r\n                            \"rowCount\": 1,\r\n                            \"addRowText\": \"Add medication\"\r\n                        }\r\n                    ],\r\n                    \"title\": \"Medication recently used\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"aspirinContainingProducts\",\r\n                    \"title\": \"Have you taken aspirin-containing products in the last two weeks?\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"steroidDrugs\",\r\n                    \"title\": \"Have you taken steroid or cortisone-type drugs within the last year?\"\r\n                }\r\n            ],\r\n            \"name\": \"medications\",\r\n            \"title\": \"Medications\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"allergiesMedication\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"hasAllergiesMedication\",\r\n                            \"title\": \"Have you had hives, skin rash, breathing problems, or other allergic reactions to medications?\"\r\n                        }, {\r\n                            \"type\": \"matrixdynamic\",\r\n                            \"name\": \"allergiesMedicationList\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{hasAllergiesMedication} = \'Yes\'\",\r\n                            \"title\": \"Medication list\",\r\n                            \"columns\": [\r\n                                {\r\n                                    \"name\": \"name\",\r\n                                    \"title\": \"Name of Medication\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"description\",\r\n                                    \"title\": \"Describe Allergic Reaction\",\r\n                                    \"cellType\": \"comment\",\r\n                                    \"isRequired\": true\r\n                                }\r\n                            ],\r\n                            \"choices\": [\r\n                                1, 2, 3, 4, 5\r\n                            ],\r\n                            \"rowCount\": 1,\r\n                            \"addRowText\": \"Add medication\"\r\n                        }\r\n                    ],\r\n                    \"title\": \"Allergies to Medication\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"unpleasentToMedication\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"hasUnpleasantMedication\",\r\n                            \"title\": \"Are there medications, other than those you are allergic to, that you would prefer not to take due to prior unpleasant side effects?\"\r\n                        }, {\r\n                            \"type\": \"matrixdynamic\",\r\n                            \"name\": \"unpleasantMedicationList\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{hasUnpleasantMedication} = \'Yes\'\",\r\n                            \"title\": \"Medication list\",\r\n                            \"columns\": [\r\n                                {\r\n                                    \"name\": \"name\",\r\n                                    \"title\": \"Name of Medication\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }, {\r\n                                    \"name\": \"description\",\r\n                                    \"title\": \"Describe the Reaction\",\r\n                                    \"cellType\": \"text\",\r\n                                    \"isRequired\": true\r\n                                }\r\n                            ],\r\n                            \"choices\": [\r\n                                1, 2, 3, 4, 5\r\n                            ],\r\n                            \"rowCount\": 1,\r\n                            \"addRowText\": \"Add medication\"\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"allergiesReaction\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"allergicReactionXRay\",\r\n                                    \"title\": \"Iodine or X-ray contrast dye\"\r\n                                }, {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"allergicReactionBee\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"title\": \"Bee or wasp stings\"\r\n                                }, {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"allergicReactionLatext\",\r\n                                    \"title\": \"Latex or Rubber\"\r\n                                }, {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"allergicReactionTape\",\r\n                                    \"startWithNewLine\": false,\r\n                                    \"title\": \"Adhesive tape\"\r\n                                }\r\n                            ],\r\n                            \"questionTitleLocation\": \"left\",\r\n                            \"title\": \"Have you had an allergic reaction to:\"\r\n                        }\r\n                    ],\r\n                    \"title\": \"Unpleasant Side Effects to Medications\"\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"foodAllergiesInfo\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"hasFoodAllergies\",\r\n                            \"title\": \"Do you have any food allergies?\"\r\n                        }, {\r\n                            \"type\": \"comment\",\r\n                            \"name\": \"foodAllergiesDescription\",\r\n                            \"title\": \"Describe\",\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{hasFoodAllergies} = \'Yes\'\"\r\n                        }\r\n                    ],\r\n                    \"questionTitleLocation\": \"left\",\r\n                    \"title\": \"Food Allergies\"\r\n                }\r\n            ],\r\n            \"name\": \"allergies\",\r\n            \"title\": \"Allergies\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"matrix\",\r\n                    \"columns\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"isAllRowRequired\": true,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"sympthoms\",\r\n                    \"rows\": [\r\n                        \"Skin rash, sore, excessive bruising or change of a mole?\",\r\n                        \"Excessive thirst or urination?\",\r\n                        \"Change in sexual drive or performance?\",\r\n                        \"Significant headaches, seizures, slurred speech or difficulty moving an arm or leg?\",\r\n                        \"Eye problems such as double or blurred vision, cataracts or glaucoma?\",\r\n                        \"Diminished hearing, dizziness, hoarseness or sinus problems?\", {\r\n                            \"value\": \"dentures\",\r\n                            \"text\": \"Do you wear dentures?\"\r\n                        },\r\n                        \"Bothered with cough, shortness of breath, wheezing or asthma?\",\r\n                        \"Coughing up sputum or blood?\",\r\n                        \"Exposed to anyone with tuberculosis?\",\r\n                        \"“Blacked out” or lost consciousness?\",\r\n                        \"Chest pain or pressure, rapid or irregular heart beats, or known difficulty with a heart valve?\",\r\n                        \"Awakening at night with shortness of breath?\",\r\n                        \"Abnormal swelling in the legs or feet?\",\r\n                        \"Pain in the calves of your legs when you walk?\",\r\n                        \"Difficulty with swallowing, heartburn, nausea, vomiting or stomach trouble?\",\r\n                        \"Significant problems with constipation, diarrhea, blood/changes in bowel movements?\", {\r\n                            \"value\": \"colon_rectum_x-ray\",\r\n                            \"text\": \"Have you had a colon or rectum x-ray or instrument examination (proctoscopy, sigmoidoscopy, colonoscopy)?\"\r\n                        }, {\r\n                            \"value\": \"endoscopy\",\r\n                            \"text\": \"Have you had an upper endoscopy to evaluate the stomach for varices?\"\r\n                        },\r\n                        \"Have you had any treatment for varices? (sclerotherapy, banding)\",\r\n                        \"Difficulty starting your urinary stream, completely emptying your bladder or leaking urine from your bladder?\",\r\n                        \"Burning or pain when urinating?\",\r\n                        \"Pain, stiffness or swelling in your back, joints or muscles?\",\r\n                        \"Fever within the last month?\",\r\n                        \"Enlarged glands (lymph nodes)?\",\r\n                        \"Feel you are at risk for HIV or AIDS?\",\r\n                        \"Immunized for influenza, tetanus/diphtheria and/or pneumonia within the last year?\",\r\n                        \"Experiencing an unusually stressful situation?\",\r\n                        \"Weight gain or loss of more than 10 pounds during the last 6 months?\",\r\n                        \"Problems falling asleep, staying asleep, sleep apnea or disruptive snoring?\",\r\n                        \"Have you ever felt a need to cut down on your alcohol consumption?\",\r\n                        \"Do relatives/friends worry or complain about your alcohol consumption?\",\r\n                        \"Have you been physically, sexually, or emotionally abused?\"\r\n                    ],\r\n                    \"title\": \"Indicate whether you have experienced the following symptoms during recent months, unless otherwise specified\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \" Ful\", \"Upper\", \"Lower\", \"Partial\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"howWearDentures\",\r\n                    \"title\": \"How do you wear dentures?\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{sympthoms.dentures}  = \'Yes\'\"\r\n                }, {\r\n                    \"type\": \"multipletext\",\r\n                    \"name\": \"colonRectumDate\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{sympthoms.colon_rectum_x-ray} = \'Yes\'\",\r\n                    \"title\": \"Whe did you do a colon or rectum x-ray or instrument examination (proctoscopy, sigmoidoscopy, colonoscopy)?  Approximate date:\",\r\n                    \"isRequired\": true,\r\n                    \"items\": [\r\n                        {\r\n                            \"name\": \"mo\",\r\n                            \"title\": \"Month\"\r\n                        }, {\r\n                            \"name\": \"year\",\r\n                            \"title\": \"Year\"\r\n                        }\r\n                    ],\r\n                    \"colCount\": 2\r\n                }, {\r\n                    \"type\": \"multipletext\",\r\n                    \"name\": \"endoscopyDate\",\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{sympthoms.endoscopy} = \'Yes\'\",\r\n                    \"title\": \"Whe did you have an upper endoscopy to evaluate the stomach for varices?  Approximate date:\",\r\n                    \"isRequired\": true,\r\n                    \"items\": [\r\n                        {\r\n                            \"name\": \"mo\",\r\n                            \"title\": \"Month\"\r\n                        }, {\r\n                            \"name\": \"year\",\r\n                            \"title\": \"Year\"\r\n                        }\r\n                    ],\r\n                    \"colCount\": 2\r\n                }, {\r\n                    \"type\": \"panel\",\r\n                    \"name\": \"questionsToFemale\",\r\n                    \"elements\": [\r\n                        {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"Unknown\", \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"abnormalPapSmear\",\r\n                            \"title\": \"Have you ever had an abnormal Pap smear?\"\r\n                        }, {\r\n                            \"type\": \"radiogroup\",\r\n                            \"choices\": [\r\n                                \"No\", \"Yes\"\r\n                            ],\r\n                            \"colCount\": 0,\r\n                            \"isRequired\": true,\r\n                            \"name\": \"menopause\",\r\n                            \"title\": \"Have you experienced menopause or had a hysterectomy?\"\r\n                        }, {\r\n                            \"type\": \"panel\",\r\n                            \"name\": \"panelNoMenopause\",\r\n                            \"elements\": [\r\n                                {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"concernedAboutMenstrualPeriods\",\r\n                                    \"title\": \"Are you concerned about your menstrual periods?\"\r\n                                }, {\r\n                                    \"type\": \"radiogroup\",\r\n                                    \"choices\": [\r\n                                        \"No\", \"Yes\"\r\n                                    ],\r\n                                    \"colCount\": 0,\r\n                                    \"isRequired\": true,\r\n                                    \"name\": \"pregnant\",\r\n                                    \"title\": \"Might you be pregnant at this time?\"\r\n                                }, {\r\n                                    \"type\": \"text\",\r\n                                    \"name\": \"lastMenstrualPeriod\",\r\n                                    \"title\": \"Date of onset of your last menstrual period:\",\r\n                                    \"inputType\": \"date\"\r\n                                }, {\r\n                                    \"type\": \"panel\",\r\n                                    \"name\": \"panelPapSmearExam\",\r\n                                    \"elements\": [\r\n                                        {\r\n                                            \"type\": \"radiogroup\",\r\n                                            \"choices\": [\r\n                                                \"No\", \"Yes\"\r\n                                            ],\r\n                                            \"colCount\": 0,\r\n                                            \"isRequired\": true,\r\n                                            \"name\": \"papSmearExam\",\r\n                                            \"title\": \"Have you ever done Pap smear and pelvic exam:\"\r\n                                        }, {\r\n                                            \"type\": \"multipletext\",\r\n                                            \"name\": \"papSmearExamDate\",\r\n                                            \"visible\": false,\r\n                                            \"visibleIf\": \"{papSmearExam} = \'Yes\'\",\r\n                                            \"title\": \"Approximate date of your last Pap smear and pelvic exam:\",\r\n                                            \"isRequired\": true,\r\n                                            \"items\": [\r\n                                                {\r\n                                                    \"name\": \"mo\",\r\n                                                    \"title\": \"Month\"\r\n                                                }, {\r\n                                                    \"name\": \"year\",\r\n                                                    \"title\": \"Year\"\r\n                                                }\r\n                                            ],\r\n                                            \"colCount\": 2\r\n                                        }, {\r\n                                            \"type\": \"radiogroup\",\r\n                                            \"choices\": [\r\n                                                \"No\", \"Yes\"\r\n                                            ],\r\n                                            \"colCount\": 0,\r\n                                            \"isRequired\": true,\r\n                                            \"name\": \"mammogram\",\r\n                                            \"title\": \"Have you ever done mammogram:\"\r\n                                        }, {\r\n                                            \"type\": \"multipletext\",\r\n                                            \"name\": \"mammogramDate\",\r\n                                            \"visible\": false,\r\n                                            \"visibleIf\": \"{mammogram} = \'Yes\'\",\r\n                                            \"title\": \"Approximate date of your last mammogram:\",\r\n                                            \"isRequired\": true,\r\n                                            \"items\": [\r\n                                                {\r\n                                                    \"name\": \"mo\",\r\n                                                    \"title\": \"Month\"\r\n                                                }, {\r\n                                                    \"name\": \"year\",\r\n                                                    \"title\": \"Year\"\r\n                                                }\r\n                                            ],\r\n                                            \"colCount\": 2\r\n                                        }\r\n                                    ]\r\n                                }, {\r\n                                    \"type\": \"panel\",\r\n                                    \"name\": \"panelPregnancies\",\r\n                                    \"elements\": [\r\n                                        {\r\n                                            \"type\": \"text\",\r\n                                            \"name\": \"pregnancies\",\r\n                                            \"title\": \"Pregnancies:\",\r\n                                            \"isRequired\": true,\r\n                                            \"inputType\": \"number\"\r\n                                        }, {\r\n                                            \"type\": \"text\",\r\n                                            \"name\": \"liveBirths\",\r\n                                            \"startWithNewLine\": false,\r\n                                            \"title\": \"Live Births:\",\r\n                                            \"isRequired\": true,\r\n                                            \"inputType\": \"number\"\r\n                                        }, {\r\n                                            \"type\": \"text\",\r\n                                            \"name\": \"abortions\",\r\n                                            \"startWithNewLine\": false,\r\n                                            \"title\": \"Miscarriages/abortions:\",\r\n                                            \"isRequired\": true,\r\n                                            \"inputType\": \"number\"\r\n                                        }\r\n                                    ],\r\n                                    \"title\": \"Number of:\"\r\n                                }\r\n                            ],\r\n                            \"visible\": false,\r\n                            \"visibleIf\": \"{menopause} = \'No\'\"\r\n                        }\r\n                    ],\r\n                    \"visible\": false,\r\n                    \"visibleIf\": \"{sex} = \'female\'\",\r\n                    \"title\": \"For Female Patients\"\r\n                }\r\n            ],\r\n            \"name\": \"systemsReview\",\r\n            \"questionTitleLocation\": \"left\",\r\n            \"title\": \"System Review\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"matrix\",\r\n                    \"columns\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"isAllRowRequired\": true,\r\n                    \"name\": \"performingActivities\",\r\n                    \"rows\": [\r\n                        \"Eating\",\r\n                        \"Bathing\",\r\n                        \"Dressing\",\r\n                        \"Walking\",\r\n                        \"Using Toilet\",\r\n                        \"Housekeeping\"\r\n                    ],\r\n                    \"title\": \"Do you have difficulty performing these activities by YOURSELF?\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"No\", \"Yes\"\r\n                    ],\r\n                    \"colCount\": \"0\",\r\n                    \"isRequired\": true,\r\n                    \"name\": \"specialDietary\",\r\n                    \"title\": \"Do you have any special dietary needs?\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"isRequired\": true,\r\n                    \"name\": \"specialDietaryDescription\",\r\n                    \"title\": \"Please describe your special dietery:\",\r\n                    \"visibleIf\": \"{specialDietary} = \'Yes\'\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"House\", \"Apartment\", \"Nursing Home\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"hasOther\": true,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"livingArrangement\",\r\n                    \"title\": \"What is your current living arrangement?\"\r\n                }, {\r\n                    \"type\": \"radiogroup\",\r\n                    \"choices\": [\r\n                        \"Alone\", \"With Spouse/Family\", \"With others\"\r\n                    ],\r\n                    \"colCount\": 0,\r\n                    \"isRequired\": true,\r\n                    \"name\": \"liveWithWhom\",\r\n                    \"title\": \"Do you live?\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"isRequired\": true,\r\n                    \"name\": \"liveWithWhomDescription\",\r\n                    \"title\": \"Please describe with whom do you live:\",\r\n                    \"visibleIf\": \"{liveWithWhom} = \'With others\'\"\r\n                }, {\r\n                    \"type\": \"comment\",\r\n                    \"name\": \"peopleProvidedAssistence\",\r\n                    \"title\": \"List family or friends able to provide assistance with your homecare needs if you would ever require such assistance:\",\r\n                    \"titleLocation\": \"top\"\r\n                }\r\n            ],\r\n            \"name\": \"selfCare\",\r\n            \"questionTitleLocation\": \"left\",\r\n            \"title\": \"Self-Care/Home Environment Assessment\"\r\n        }, {\r\n            \"elements\": [\r\n                {\r\n                    \"type\": \"checkbox\",\r\n                    \"choices\": [\r\n                        \"How to stop smoking\",\r\n                        \"Exercise\",\r\n                        \"Stress\",\r\n                        \"Safe sexual practices\",\r\n                        \"Safety (seat belts, smoke detectors, firearms)\",\r\n                        \"Nutrition\",\r\n                        \"Weight control\",\r\n                        \"Violent & abusive behavior\",\r\n                        \"Living wills\",\r\n                        \"Diabetes\",\r\n                        \"Cancer screening   \"\r\n                    ],\r\n                    \"colCount\": \"3\",\r\n                    \"hasOther\": true,\r\n                    \"name\": \"interestedInTopics\",\r\n                    \"title\": \"Are you interested in more information about a specific topic(s)?\"\r\n                }\r\n            ],\r\n            \"name\": \"educationalNeeds\",\r\n            \"title\": \"Educational Needs\"\r\n        }\r\n    ],\r\n    \"showProgressBar\": \"top\",\r\n    \"showQuestionNumbers\": \"off\",\r\n    \"title\": \"Patient Past Medical, Social & Family History\"\r\n};',2,'2021-12-08 19:23:11','2026-12-30 23:55:55','2021-12-11 19:22:01','admin','2025-05-14 14:02:21','admin');
/*!40000 ALTER TABLE `survey` ENABLE KEYS */;




--
-- Definition of table `response`
--

DROP TABLE IF EXISTS `response`;
CREATE TABLE `response` (
  `id_response` int(11) NOT NULL AUTO_INCREMENT,
  `survey_id` int(11) NOT NULL,
  `status` varchar(1) NOT NULL DEFAULT '0',
  `responseDate` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ip` varchar(15) DEFAULT NULL,
  `json` mediumtext NOT NULL,
  PRIMARY KEY (`id_response`),
  KEY `fk_response_survey1_idx` (`survey_id`),
  CONSTRAINT `fk_response_survey1` FOREIGN KEY (`survey_id`) REFERENCES `survey` (`id_survey`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `response`
--

/*!40000 ALTER TABLE `response` DISABLE KEYS */;
INSERT INTO `response` (`id_response`,`survey_id`,`status`,`responseDate`,`ip`,`json`) VALUES 
 (1,1,'1','2021-12-15 19:08:43','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"other\"],\"disappointed_experience\":\"Esto es una prueba\",\"promoter_features-Comment\":\"Pruebas 2\"}'),
 (2,1,'1','2021-12-10 17:51:27','127.0.0.1','{\"nps_score\":8,\"passive_experience\":\"Pruebas 1\",\"disappointed_experience\":\"Pruebas2\"}'),
 (3,1,'1','2021-12-10 17:54:49','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Rendimiento\",\"Funcionalidad completa\"],\"disappointed_experience\":\"Pruebas 1\"}'),
 (4,1,'1','2021-12-10 17:55:39','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"other\"],\"disappointed_experience\":\"Pruebas 2\",\"promoter_features-Comment\":\"Pruebas 1\"}'),
 (5,1,'1','2021-12-10 19:28:42','127.0.0.1','{\"nps_score\":7,\"passive_experience\":\"vcvc\",\"disappointed_experience\":\"vcvcgtgttt\"}'),
 (6,1,'1','2021-12-10 19:36:51','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Estabilidad\",\"Interfaz de usuario\"],\"disappointed_experience\":\"dedede\"}'),
 (7,1,'1','2021-12-10 19:38:02','127.0.0.1','{\"nps_score\":7,\"passive_experience\":\"frfr\",\"disappointed_experience\":\"frfrf\"}'),
 (8,1,'1','2021-12-10 19:44:41','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Estabilidad\",\"Rendimiento\"],\"disappointed_experience\":\"Pruebas 1\"}'),
 (9,1,'1','2021-12-10 20:45:43','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Estabilidad\",\"Interfaz de usuario\"],\"disappointed_experience\":\"gtgtg\"}'),
 (10,1,'1','2021-12-10 20:57:30','127.0.0.1','{\"nps_score\":10,\"promoter_features\":[\"Estabilidad\",\"Interfaz de usuario\"],\"disappointed_experience\":\"frfrfrf\"}'),
 (11,2,'1','2021-12-11 18:54:38','127.0.0.1','{\"satisfaction\":3}'),
 (12,2,'1','2021-12-11 19:15:20','127.0.0.1','{\"satisfaction\":2,\"What should be improved?\":[\"1\",\"2\",\"3\"],\"suggestions\":\"Texto de prueba\",\"name\":\"Fernando\",\"email\":\"info@fhumanes.com\"}'),
 (13,3,'1','2021-12-11 19:25:47','127.0.0.1','{\"Feelings\":{\"Excited\":{\"col1\":\"Disagree\",\"comment\":\"Comment 1\"},\"Enthusiastic\":{\"col1\":\"Agree\",\"comment\":\"Comment 2\"},\"Open\":{\"col1\":\"Disagree\",\"comment\":\"Comment 3\"},\"Physically safe\":{\"col1\":\"Strongly disagree\",\"comment\":\"Comment 4\"},\"Emotionally safe\":{\"col1\":\"Agree\",\"comment\":\"Comment 5\"},\"Apprehensive\":{\"col1\":\"Strongly disagree\",\"comment\":\"Comment 6\"},\"Nervous\":{\"col1\":\"Disagree\",\"comment\":\"Comment 7\"},\"Scared\":{\"col1\":\"Agree\",\"comment\":\"Comment 8\"}}}'),
 (14,4,'1','2021-12-11 19:34:25','127.0.0.1','{\"relatives\":[{\"isalive\":\"Yes\",\"relativeType\":\"father\",\"firstName\":\"Fernando\",\"lastName\":\"H\",\"liveage\":60},{\"isalive\":\"Yes\",\"relativeType\":\"mother\",\"firstName\":\"Ángela\",\"lastName\":\"L\",\"liveage\":60},{\"isalive\":\"Yes\",\"relativeType\":\"mother\",\"firstName\":\"Rosa\",\"lastName\":\"G\",\"liveage\":80},{\"isalive\":\"Yes\",\"relativeType\":\"son\",\"firstName\":\"Pablo\",\"lastName\":\"H\",\"liveage\":32},{\"isalive\":\"Yes\",\"relativeType\":\"brother\",\"firstName\":\"Ángel\",\"lastName\":\"U\",\"liveage\":48}]}'),
 (15,4,'1','2021-12-11 19:36:21','127.0.0.1','{\"relatives\":[{\"isalive\":\"No\",\"deceasedage\":86,\"causeofdeathknown\":\"Yes\",\"relativeType\":\"father\",\"firstName\":\"Ángel\",\"lastName\":\"H\",\"causeofdeath\":\"other\"}]}'),
 (16,5,'1','2021-12-11 19:50:35','127.0.0.1','{\"address1\":\"Calle Alcala, 32\",\"address2\":\"Hotel\",\"city\":\"Madrid\",\"state\":\"Madrid\",\"zip\":\"28015\",\"country\":\"Spain\"}'),
 (17,6,'1','2021-12-11 19:55:34','127.0.0.1','{\"civilwar\":\"1800-1850\",\"libertyordeath\":\"Samuel Adams\",\"magnacarta\":\"The Great Seal of the monarchs of England\"}'),
 (18,7,'1','2021-12-11 20:01:12','127.0.0.1','{\"employers\":[{\"name\":\"fernando\",\"hours_worked_frequency\":\"Year\",\"income_frequency\":\"Year\",\"address\":\"Calle Alcalá, 32\",\"phone\":\"630630630\",\"role\":\"Full time\",\"hours_worked\":8,\"income\":1500}]}'),
 (19,8,'1','2021-12-11 20:10:25','127.0.0.1','{\"opSystem\":[\"Windows\"],\"langs\":[\"PHP\",\"Javascript\"],\"name\":\"fernando\",\"email\":\"info@fhumanes.com\"}'),
 (20,9,'1','2021-12-11 20:38:29','127.0.0.1','{\"date\":\"12/15/2021\"}'),
 (21,1,'1','2021-12-14 13:11:38','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Interfaz de usuario\",\"other\"],\"disappointed_experience\":\"Pruebas 2\",\"promoter_features-Comment\":\"Pruebas 1\"}'),
 (22,1,'1','2021-12-14 13:29:16','127.0.0.1','{\"nps_score\":1}'),
 (23,3,'1','2021-12-14 13:40:31','127.0.0.1','{\"Feelings\":{\"Excited\":{\"col1\":\"Neutral\"},\"Enthusiastic\":{\"col1\":\"Neutral\"},\"Open\":{\"col1\":\"Neutral\"},\"Physically safe\":{\"col1\":\"Neutral\"},\"Emotionally safe\":{\"col1\":\"Neutral\"},\"Apprehensive\":{\"col1\":\"Neutral\"},\"Nervous\":{\"col1\":\"Neutral\"},\"Scared\":{\"col1\":\"Neutral\"}}}'),
 (24,3,'1','2021-12-14 13:43:15','127.0.0.1','{\"Feelings\":{\"Excited\":{\"col1\":\"Strongly disagree\",\"comment\":\"Pruebas pruebas y pruebas\"},\"Enthusiastic\":{\"col1\":\"Strongly disagree\"},\"Open\":{\"col1\":\"Strongly disagree\"},\"Physically safe\":{\"col1\":\"Strongly disagree\"},\"Emotionally safe\":{\"col1\":\"Strongly disagree\"},\"Apprehensive\":{\"col1\":\"Strongly disagree\"},\"Nervous\":{\"col1\":\"Strongly disagree\"},\"Scared\":{\"col1\":\"Strongly disagree\"}}}'),
 (25,1,'1','2021-12-14 13:51:26','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Interfaz de usuario\",\"Funcionalidad completa\"],\"disappointed_experience\":\"Pruebas\"}'),
 (26,1,'1','2021-12-14 14:03:33','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Rendimiento\",\"Interfaz de usuario\"]}'),
 (27,1,'1','2021-12-14 14:08:19','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Rendimiento\"],\"disappointed_experience\":\"frffrf\"}'),
 (28,1,'1','2021-12-14 15:46:13','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Rendimiento\",\"Interfaz de usuario\"],\"disappointed_experience\":\"Pruebas\"}'),
 (30,12,'1','2021-12-14 20:54:10','127.0.0.1','{\"patientLastName\":\"Hum\",\"patienFirstName\":\"Fer\",\"patientMiddleName\":\"Per\",\"socialsecurity\":\"111-11-1111\",\"birthDate\":\"2010-06-10\",\"sex\":\"male\",\"completedBy\":\"patient\",\"everhospitalized\":\"yes\",\"injuriesbrokenbones\":\"no\",\"bloodtransfusion\":\"yes\",\"bloodtransfusion_years\":\"3\",\"ousideUSACanada\":\"yes\",\"ousideUSACanada_describe\":\"In Spain\",\"immunizations\":{\"Pneumococcal (for pneumonia)\":{\"answer\":\"yes\",\"year\":\"2014\"},\"Hepatitis A\":{\"answer\":\"no\"},\"Hepatitis B\":{\"answer\":\"no\"},\"Tetanus/Diphtheria within last 10 years\":{\"answer\":\"yes\",\"year\":\"1958\"},\"Influenza (flu)\":{\"answer\":\"no\"},\"Measles\":{\"answer\":\"unknown\"},\"Mumps\":{\"answer\":\"unknown\"},\"Rubella\":{\"answer\":\"unknown\"},\"Polio\":{\"answer\":\"unknown\"}},\"problems1\":[{\"problem\":\"High blood pressure\",\"answer\":\"yes\",\"description\":\"descriptions\"}],\"problems2\":[{\"problem\":\"Coronary (heart) arteries (angina)\",\"type\":[\"medical\"],\"describe\":\".\"}],\"schoolYearsCompleted\":10,\"employmentStatus\":\"Employed\",\"currentOcupation\":\"Developer\",\"previousOccupations\":\"Studient\",\"disabled\":\"No\",\"abused\":\"No\",\"subsctancesUsing\":{\"Caffeine: coffee, tea, soda\":{\"current\":\"Yes\",\"previous\":\"Yes\",\"amount\":\"coffee\",\"long\":\"10\",\"stopped\":\"1\"},\"Tobacco\":{\"current\":\"No\",\"previous\":\"No\"},\"Alcohol - bear, wine, liquor\":{\"current\":\"No\",\"previous\":\"No\"},\"Recreational/Street drugs\":{\"current\":\"No\",\"previous\":\"No\"}},\"currentlyMarried\":\"Yes\",\"currentMarriageYear\":\"5\",\"previousMarriages\":[{\"previousMarriageYear\":\"2015\",\"previousMarriageDuration\":\"5\"}],\"currentSpouseStatus\":\"Not applicable\",\"adopted\":\"No\",\"bloodRelativesInfo\":[{\"relativeType\":\"Father\",\"relativeStatus\":\"Deceased\",\"relativeAgeOfDeath\":\"2016\",\"relativeCauseOfDeath\":\"Known\",\"relativeCauseOfDeathDescription\":\".\",\"relativeCondition\":[{\"name\":\"Other\",\"description\":\".\"}]}],\"relativesAdditionalInfo\":\".\",\"primaryCareProvider\":\"No\",\"primaryCareProviderRecommend\":\"No\",\"currentMedication\":\"No\",\"recentlyUsedMedication\":\"No\",\"aspirinContainingProducts\":\"No\",\"steroidDrugs\":\"No\",\"hasAllergiesMedication\":\"No\",\"hasUnpleasantMedication\":\"No\",\"allergicReactionXRay\":\"No\",\"allergicReactionBee\":\"No\",\"allergicReactionLatext\":\"No\",\"allergicReactionTape\":\"No\",\"hasFoodAllergies\":\"No\",\"sympthoms\":{\"Skin rash, sore, excessive bruising or change of a mole?\":\"No\",\"Excessive thirst or urination?\":\"No\",\"Change in sexual drive or performance?\":\"No\",\"Significant headaches, seizures, slurred speech or difficulty moving an arm or leg?\":\"No\",\"Eye problems such as double or blurred vision, cataracts or glaucoma?\":\"No\",\"Diminished hearing, dizziness, hoarseness or sinus problems?\":\"No\",\"dentures\":\"No\",\"Bothered with cough, shortness of breath, wheezing or asthma?\":\"No\",\"Coughing up sputum or blood?\":\"No\",\"Exposed to anyone with tuberculosis?\":\"No\",\"“Blacked out” or lost consciousness?\":\"No\",\"Chest pain or pressure, rapid or irregular heart beats, or known difficulty with a heart valve?\":\"No\",\"Awakening at night with shortness of breath?\":\"No\",\"Abnormal swelling in the legs or feet?\":\"No\",\"Pain in the calves of your legs when you walk?\":\"No\",\"Difficulty with swallowing, heartburn, nausea, vomiting or stomach trouble?\":\"No\",\"Significant problems with constipation, diarrhea, blood/changes in bowel movements?\":\"No\",\"colon_rectum_x-ray\":\"No\",\"endoscopy\":\"No\",\"Have you had any treatment for varices? (sclerotherapy, banding)\":\"No\",\"Difficulty starting your urinary stream, completely emptying your bladder or leaking urine from your bladder?\":\"No\",\"Burning or pain when urinating?\":\"No\",\"Pain, stiffness or swelling in your back, joints or muscles?\":\"No\",\"Fever within the last month?\":\"No\",\"Enlarged glands (lymph nodes)?\":\"No\",\"Feel you are at risk for HIV or AIDS?\":\"No\",\"Immunized for influenza, tetanus/diphtheria and/or pneumonia within the last year?\":\"No\",\"Experiencing an unusually stressful situation?\":\"No\",\"Weight gain or loss of more than 10 pounds during the last 6 months?\":\"No\",\"Problems falling asleep, staying asleep, sleep apnea or disruptive snoring?\":\"No\",\"Have you ever felt a need to cut down on your alcohol consumption?\":\"No\",\"Do relatives/friends worry or complain about your alcohol consumption?\":\"No\",\"Have you been physically, sexually, or emotionally abused?\":\"No\"},\"performingActivities\":{\"Eating\":\"No\",\"Bathing\":\"No\",\"Dressing\":\"No\",\"Walking\":\"No\",\"Using Toilet\":\"No\",\"Housekeeping\":\"No\"},\"specialDietary\":\"No\",\"livingArrangement\":\"House\",\"liveWithWhom\":\"Alone\",\"interestedInTopics\":[\"How to stop smoking\",\"Safe sexual practices\"]}'),
 (31,1,'1','2021-12-15 19:11:46','127.0.0.1','{\"nps_score\":8,\"passive_experience\":\"deded\",\"disappointed_experience\":\"grtgtgtt\"}'),
 (32,1,'1','2022-07-23 21:16:13','127.0.0.1','{\"nps_score\":6,\"disappointed_experience\":\"Test\"}'),
 (33,6,'1','2022-07-23 21:17:10','127.0.0.1','{\"civilwar\":\"1800-1850\",\"libertyordeath\":\"Patrick Henry\",\"magnacarta\":\"The French Declaration of the Rights of Man\"}'),
 (34,1,'1','2025-05-14 14:03:50','127.0.0.1','{\"nps_score\":9,\"promoter_features\":[\"Rendimiento\",\"Estabilidad\"],\"disappointed_experience\":\"Nada importante\"}');
/*!40000 ALTER TABLE `response` ENABLE KEYS */;



/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
